function estimator=Estimation(y,p)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% MATLAB code: Example 6.2
% file: Estimation.m
% coded by Dong Li
%
% y = data set;
% p = [p1,p2,p3] is the orders of the regimes;
% estimator = [parameters, sum of residual^2,thresholds, AIC, d];
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
n   = length(y);
yy  = sort(y);
a   = 0.1;            % Change this number

d0 = max(max(p),1); % The initial value of d 
D  = zeros(d0,sum(p+1)+11);   % 8 by just AIC
m  = round(0.5*n*(1-3*a)*(n*(1-3*a)+1));
n2 = round(n*a);
n3 = round(n*(1-3*a));
A  = zeros(m,sum(p+1)+11);   % 8 by AIC

for d=1:d0 
    for j=1:n3
        for i=1:(n3-j+1)
           [beta,RSS,sigma,AIC,AICC,AICU,BIC]=estimationKnownThreshold(y,p,d,yy(j+n2),yy(i+j+2*n2));
%           [signcv,n1cv,n2cv,n3cv]=critcv3(y,p,d,yy(j+n2),yy(i+j+2*n2));            
           A(i+(j-1)*n3-(j-1)*(j-2)/2,:)=[beta,yy(j+n2),yy(i+j+2*n2),d,RSS,sigma,AIC,AICC,AICU,BIC];
        end;
    end;
    [~,I]  = min(A(:,sum(p+1)+7));   % 4 for just AIC
    D(d,:) = A(I,:);
end;     

[~,L] = min(D(:,sum(p+1)+7));     % make changes   
estimator=D(L,:);
